/*
 * q_srv02_volt.c
 *
 * Real-Time Workshop code generation for Simulink model "q_srv02_volt.mdl".
 *
 * Model version              : 1.174
 * Real-Time Workshop version : 7.5  (R2010a)  25-Jan-2010
 * C source code generated on : Mon Dec 05 11:08:56 2011
 *
 * Target selection: quarc_windows.tlc
 * Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "q_srv02_volt.h"
#include "q_srv02_volt_private.h"
#include <stdio.h>
#include "q_srv02_volt_dt.h"

/* Block signals (auto storage) */
BlockIO_q_srv02_volt q_srv02_volt_B;

/* Block states (auto storage) */
D_Work_q_srv02_volt q_srv02_volt_DWork;

/* Real-time model */
RT_MODEL_q_srv02_volt q_srv02_volt_M_;
RT_MODEL_q_srv02_volt *q_srv02_volt_M = &q_srv02_volt_M_;

/* Model output function */
void q_srv02_volt_output(int_T tid)
{
  real_T temp;

  /* SignalGenerator: '<Root>/Signal Generator' */
  temp = 6.2831853071795862E+000 * q_srv02_volt_M->Timing.t[0];
  q_srv02_volt_B.SignalGenerator = sin(q_srv02_volt_P.SignalGenerator_Frequency *
    temp) * q_srv02_volt_P.SignalGenerator_Amplitude;

  /* Gain: '<S1>/Slider Gain' */
  q_srv02_volt_B.SliderGain = q_srv02_volt_P.SliderGain_Gain *
    q_srv02_volt_B.SignalGenerator;

  /* S-Function (hil_write_analog_block): '<Root>/HIL Write Analog' */

  /* S-Function Block: q_srv02_volt/HIL Write Analog (hil_write_analog_block) */
  {
    t_error result;
    result = hil_write_analog(q_srv02_volt_DWork.HILInitialize_Card,
      &q_srv02_volt_P.HILWriteAnalog_Channels, 1, &q_srv02_volt_B.SliderGain);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
    }
  }

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Model update function */
void q_srv02_volt_update(int_T tid)
{
  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++q_srv02_volt_M->Timing.clockTick0)) {
    ++q_srv02_volt_M->Timing.clockTickH0;
  }

  q_srv02_volt_M->Timing.t[0] = q_srv02_volt_M->Timing.clockTick0 *
    q_srv02_volt_M->Timing.stepSize0 + q_srv02_volt_M->Timing.clockTickH0 *
    q_srv02_volt_M->Timing.stepSize0 * 4294967296.0;

  {
    /* Update absolute timer for sample time: [0.001s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick1"
     * and "Timing.stepSize1". Size of "clockTick1" ensures timer will not
     * overflow during the application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    if (!(++q_srv02_volt_M->Timing.clockTick1)) {
      ++q_srv02_volt_M->Timing.clockTickH1;
    }

    q_srv02_volt_M->Timing.t[1] = q_srv02_volt_M->Timing.clockTick1 *
      q_srv02_volt_M->Timing.stepSize1 + q_srv02_volt_M->Timing.clockTickH1 *
      q_srv02_volt_M->Timing.stepSize1 * 4294967296.0;
  }

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Model initialize function */
void q_srv02_volt_initialize(boolean_T firstTime)
{
  (void)firstTime;

  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* initialize real-time model */
  (void) memset((void *)q_srv02_volt_M, 0,
                sizeof(RT_MODEL_q_srv02_volt));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&q_srv02_volt_M->solverInfo,
                          &q_srv02_volt_M->Timing.simTimeStep);
    rtsiSetTPtr(&q_srv02_volt_M->solverInfo, &rtmGetTPtr(q_srv02_volt_M));
    rtsiSetStepSizePtr(&q_srv02_volt_M->solverInfo,
                       &q_srv02_volt_M->Timing.stepSize0);
    rtsiSetErrorStatusPtr(&q_srv02_volt_M->solverInfo, (&rtmGetErrorStatus
      (q_srv02_volt_M)));
    rtsiSetRTModelPtr(&q_srv02_volt_M->solverInfo, q_srv02_volt_M);
  }

  rtsiSetSimTimeStep(&q_srv02_volt_M->solverInfo, MAJOR_TIME_STEP);
  rtsiSetSolverName(&q_srv02_volt_M->solverInfo,"FixedStepDiscrete");

  /* Initialize timing info */
  {
    int_T *mdlTsMap = q_srv02_volt_M->Timing.sampleTimeTaskIDArray;
    mdlTsMap[0] = 0;
    mdlTsMap[1] = 1;
    q_srv02_volt_M->Timing.sampleTimeTaskIDPtr = (&mdlTsMap[0]);
    q_srv02_volt_M->Timing.sampleTimes =
      (&q_srv02_volt_M->Timing.sampleTimesArray[0]);
    q_srv02_volt_M->Timing.offsetTimes =
      (&q_srv02_volt_M->Timing.offsetTimesArray[0]);

    /* task periods */
    q_srv02_volt_M->Timing.sampleTimes[0] = (0.0);
    q_srv02_volt_M->Timing.sampleTimes[1] = (0.001);

    /* task offsets */
    q_srv02_volt_M->Timing.offsetTimes[0] = (0.0);
    q_srv02_volt_M->Timing.offsetTimes[1] = (0.0);
  }

  rtmSetTPtr(q_srv02_volt_M, &q_srv02_volt_M->Timing.tArray[0]);

  {
    int_T *mdlSampleHits = q_srv02_volt_M->Timing.sampleHitArray;
    mdlSampleHits[0] = 1;
    mdlSampleHits[1] = 1;
    q_srv02_volt_M->Timing.sampleHits = (&mdlSampleHits[0]);
  }

  rtmSetTFinal(q_srv02_volt_M, -1);
  q_srv02_volt_M->Timing.stepSize0 = 0.001;
  q_srv02_volt_M->Timing.stepSize1 = 0.001;

  /* external mode info */
  q_srv02_volt_M->Sizes.checksums[0] = (2525362616U);
  q_srv02_volt_M->Sizes.checksums[1] = (2333954859U);
  q_srv02_volt_M->Sizes.checksums[2] = (1404890261U);
  q_srv02_volt_M->Sizes.checksums[3] = (1654765120U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[1];
    q_srv02_volt_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(q_srv02_volt_M->extModeInfo,
      &q_srv02_volt_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(q_srv02_volt_M->extModeInfo,
                        q_srv02_volt_M->Sizes.checksums);
    rteiSetTPtr(q_srv02_volt_M->extModeInfo, rtmGetTPtr(q_srv02_volt_M));
  }

  q_srv02_volt_M->solverInfoPtr = (&q_srv02_volt_M->solverInfo);
  q_srv02_volt_M->Timing.stepSize = (0.001);
  rtsiSetFixedStepSize(&q_srv02_volt_M->solverInfo, 0.001);
  rtsiSetSolverMode(&q_srv02_volt_M->solverInfo, SOLVER_MODE_SINGLETASKING);

  /* block I/O */
  q_srv02_volt_M->ModelData.blockIO = ((void *) &q_srv02_volt_B);

  {
    q_srv02_volt_B.SignalGenerator = 0.0;
    q_srv02_volt_B.SliderGain = 0.0;
  }

  /* parameters */
  q_srv02_volt_M->ModelData.defaultParam = ((real_T *)&q_srv02_volt_P);

  /* states (dwork) */
  q_srv02_volt_M->Work.dwork = ((void *) &q_srv02_volt_DWork);
  (void) memset((void *)&q_srv02_volt_DWork, 0,
                sizeof(D_Work_q_srv02_volt));

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_AIMinimums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_AIMaximums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_AOMinimums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_AOMaximums[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_AOVoltages[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_FilterFrequency[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_POSortedFreqs[i] = 0.0;
    }
  }

  {
    int_T i;
    for (i = 0; i < 8; i++) {
      q_srv02_volt_DWork.HILInitialize_POValues[i] = 0.0;
    }
  }

  /* data type transition information */
  {
    static DataTypeTransInfo dtInfo;
    (void) memset((char_T *) &dtInfo, 0,
                  sizeof(dtInfo));
    q_srv02_volt_M->SpecialInfo.mappingInfo = (&dtInfo);
    dtInfo.numDataTypes = 15;
    dtInfo.dataTypeSizes = &rtDataTypeSizes[0];
    dtInfo.dataTypeNames = &rtDataTypeNames[0];

    /* Block I/O transition table */
    dtInfo.B = &rtBTransTable;

    /* Parameters transition table */
    dtInfo.P = &rtPTransTable;
  }
}

/* Model terminate function */
void q_srv02_volt_terminate(void)
{
  /* Terminate for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: q_srv02_volt/HIL Initialize (hil_initialize_block) */
  {
    t_boolean is_switching;
    t_int result;
    hil_task_stop_all(q_srv02_volt_DWork.HILInitialize_Card);
    hil_task_delete_all(q_srv02_volt_DWork.HILInitialize_Card);
    hil_monitor_stop_all(q_srv02_volt_DWork.HILInitialize_Card);
    hil_monitor_delete_all(q_srv02_volt_DWork.HILInitialize_Card);
    is_switching = reconfiguration_is_switching_out(_reconfiguration);
    if ((q_srv02_volt_P.HILInitialize_AOTerminate && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_AOExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_volt_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_volt_P.HILInitialize_AOFinal;
        }
      }

      result = hil_write_analog(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_AOChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
      }
    }

    if ((q_srv02_volt_P.HILInitialize_POTerminate && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_POExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_volt_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_volt_P.HILInitialize_POFinal;
        }
      }

      result = hil_write_pwm(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
      }
    }

    hil_close(q_srv02_volt_DWork.HILInitialize_Card);
    q_srv02_volt_DWork.HILInitialize_Card = NULL;
  }
}

/*========================================================================*
 * Start of GRT compatible call interface                                 *
 *========================================================================*/
void MdlOutputs(int_T tid)
{
  q_srv02_volt_output(tid);
}

void MdlUpdate(int_T tid)
{
  q_srv02_volt_update(tid);
}

void MdlInitializeSizes(void)
{
  q_srv02_volt_M->Sizes.numContStates = (0);/* Number of continuous states */
  q_srv02_volt_M->Sizes.numY = (0);    /* Number of model outputs */
  q_srv02_volt_M->Sizes.numU = (0);    /* Number of model inputs */
  q_srv02_volt_M->Sizes.sysDirFeedThru = (0);/* The model is not direct feedthrough */
  q_srv02_volt_M->Sizes.numSampTimes = (2);/* Number of sample times */
  q_srv02_volt_M->Sizes.numBlocks = (4);/* Number of blocks */
  q_srv02_volt_M->Sizes.numBlockIO = (2);/* Number of block outputs */
  q_srv02_volt_M->Sizes.numBlockPrms = (97);/* Sum of parameter "widths" */
}

void MdlInitializeSampleTimes(void)
{
}

void MdlInitialize(void)
{
}

void MdlStart(void)
{
  /* Start for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: q_srv02_volt/HIL Initialize (hil_initialize_block) */
  {
    t_int result;
    t_boolean is_switching;
    result = hil_open("q8_usb", "0", &q_srv02_volt_DWork.HILInitialize_Card);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
      return;
    }

    is_switching = reconfiguration_is_switching_in(_reconfiguration);
    result = hil_set_card_specific_options(q_srv02_volt_DWork.HILInitialize_Card,
      "update_rate=normal", 19);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
      return;
    }

    result = hil_watchdog_clear(q_srv02_volt_DWork.HILInitialize_Card);
    if (result < 0 && result != -QERR_HIL_WATCHDOG_CLEAR) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
      return;
    }

    if ((q_srv02_volt_P.HILInitialize_AIPStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_AIPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AIMinimums = &q_srv02_volt_DWork.HILInitialize_AIMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMinimums[i1] = q_srv02_volt_P.HILInitialize_AILow;
        }
      }

      {
        int_T i1;
        real_T *dw_AIMaximums = &q_srv02_volt_DWork.HILInitialize_AIMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMaximums[i1] = q_srv02_volt_P.HILInitialize_AIHigh;
        }
      }

      result = hil_set_analog_input_ranges(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_AIChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_AIMinimums[0],
        &q_srv02_volt_DWork.HILInitialize_AIMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_AOPStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_AOPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOMinimums = &q_srv02_volt_DWork.HILInitialize_AOMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMinimums[i1] = q_srv02_volt_P.HILInitialize_AOLow;
        }
      }

      {
        int_T i1;
        real_T *dw_AOMaximums = &q_srv02_volt_DWork.HILInitialize_AOMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMaximums[i1] = q_srv02_volt_P.HILInitialize_AOHigh;
        }
      }

      result = hil_set_analog_output_ranges
        (q_srv02_volt_DWork.HILInitialize_Card,
         &q_srv02_volt_P.HILInitialize_AOChannels[0], 8U,
         &q_srv02_volt_DWork.HILInitialize_AOMinimums[0],
         &q_srv02_volt_DWork.HILInitialize_AOMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_AOStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_AOEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_volt_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_volt_P.HILInitialize_AOInitial;
        }
      }

      result = hil_write_analog(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_AOChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if (q_srv02_volt_P.HILInitialize_AOReset) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &q_srv02_volt_DWork.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = q_srv02_volt_P.HILInitialize_AOWatchdog;
        }
      }

      result = hil_watchdog_set_analog_expiration_state
        (q_srv02_volt_DWork.HILInitialize_Card,
         &q_srv02_volt_P.HILInitialize_AOChannels[0], 8U,
         &q_srv02_volt_DWork.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_EIPStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_EIPEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_QuadratureModes =
          &q_srv02_volt_DWork.HILInitialize_QuadratureModes[0];
        for (i1=0; i1 < 8; i1++) {
          dw_QuadratureModes[i1] = q_srv02_volt_P.HILInitialize_EIQuadrature;
        }
      }

      result = hil_set_encoder_quadrature_mode
        (q_srv02_volt_DWork.HILInitialize_Card,
         &q_srv02_volt_P.HILInitialize_EIChannels[0], 8U,
         (t_encoder_quadrature_mode *)
         &q_srv02_volt_DWork.HILInitialize_QuadratureModes[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_EIStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_EIEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_InitialEICounts =
          &q_srv02_volt_DWork.HILInitialize_InitialEICounts[0];
        for (i1=0; i1 < 8; i1++) {
          dw_InitialEICounts[i1] = q_srv02_volt_P.HILInitialize_EIInitial;
        }
      }

      result = hil_set_encoder_counts(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_EIChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_InitialEICounts[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_POPStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_POPEnter && is_switching)) {
      uint32_T num_duty_cycle_modes = 0;
      uint32_T num_frequency_modes = 0;

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &q_srv02_volt_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = q_srv02_volt_P.HILInitialize_POModes;
        }
      }

      result = hil_set_pwm_mode(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_POChannels[0], 8U, (t_pwm_mode *)
        &q_srv02_volt_DWork.HILInitialize_POModeValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        const uint32_T *p_HILInitialize_POChannels =
          &q_srv02_volt_P.HILInitialize_POChannels[0];
        int32_T *dw_POModeValues =
          &q_srv02_volt_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          if (dw_POModeValues[i1] == PWM_DUTY_CYCLE_MODE || dw_POModeValues[i1] ==
              PWM_ONE_SHOT_MODE || dw_POModeValues[i1] == PWM_TIME_MODE) {
            q_srv02_volt_DWork.HILInitialize_POSortedChans[num_duty_cycle_modes]
              = (p_HILInitialize_POChannels[i1]);
            q_srv02_volt_DWork.HILInitialize_POSortedFreqs[num_duty_cycle_modes]
              = q_srv02_volt_P.HILInitialize_POFrequency;
            num_duty_cycle_modes++;
          } else {
            q_srv02_volt_DWork.HILInitialize_POSortedChans[7U -
              num_frequency_modes] = (p_HILInitialize_POChannels[i1]);
            q_srv02_volt_DWork.HILInitialize_POSortedFreqs[7U -
              num_frequency_modes] = q_srv02_volt_P.HILInitialize_POFrequency;
            num_frequency_modes++;
          }
        }
      }

      if (num_duty_cycle_modes > 0) {
        result = hil_set_pwm_frequency(q_srv02_volt_DWork.HILInitialize_Card,
          &q_srv02_volt_DWork.HILInitialize_POSortedChans[0],
          num_duty_cycle_modes, &q_srv02_volt_DWork.HILInitialize_POSortedFreqs
          [0]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
          return;
        }
      }

      if (num_frequency_modes > 0) {
        result = hil_set_pwm_duty_cycle(q_srv02_volt_DWork.HILInitialize_Card,
          &q_srv02_volt_DWork.HILInitialize_POSortedChans[num_duty_cycle_modes],
          num_frequency_modes,
          &q_srv02_volt_DWork.HILInitialize_POSortedFreqs[num_duty_cycle_modes]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
          return;
        }
      }

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &q_srv02_volt_DWork.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = q_srv02_volt_P.HILInitialize_POConfiguration;
        }
      }

      {
        int_T i1;
        int32_T *dw_POAlignValues =
          &q_srv02_volt_DWork.HILInitialize_POAlignValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POAlignValues[i1] = q_srv02_volt_P.HILInitialize_POAlignment;
        }
      }

      {
        int_T i1;
        int32_T *dw_POPolarityVals =
          &q_srv02_volt_DWork.HILInitialize_POPolarityVals[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POPolarityVals[i1] = q_srv02_volt_P.HILInitialize_POPolarity;
        }
      }

      result = hil_set_pwm_configuration(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_POChannels[0], 8U,
        (t_pwm_configuration *) &q_srv02_volt_DWork.HILInitialize_POModeValues[0],
        (t_pwm_alignment *) &q_srv02_volt_DWork.HILInitialize_POAlignValues[0],
        (t_pwm_polarity *) &q_srv02_volt_DWork.HILInitialize_POPolarityVals[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        real_T *dw_POSortedFreqs =
          &q_srv02_volt_DWork.HILInitialize_POSortedFreqs[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POSortedFreqs[i1] = q_srv02_volt_P.HILInitialize_POLeading;
        }
      }

      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_volt_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_volt_P.HILInitialize_POTrailing;
        }
      }

      result = hil_set_pwm_deadband(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_POSortedFreqs[0],
        &q_srv02_volt_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if ((q_srv02_volt_P.HILInitialize_POStart && !is_switching) ||
        (q_srv02_volt_P.HILInitialize_POEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_volt_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_volt_P.HILInitialize_POInitial;
        }
      }

      result = hil_write_pwm(q_srv02_volt_DWork.HILInitialize_Card,
        &q_srv02_volt_P.HILInitialize_POChannels[0], 8U,
        &q_srv02_volt_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }

    if (q_srv02_volt_P.HILInitialize_POReset) {
      {
        int_T i1;
        real_T *dw_POValues = &q_srv02_volt_DWork.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = q_srv02_volt_P.HILInitialize_POWatchdog;
        }
      }

      result = hil_watchdog_set_pwm_expiration_state
        (q_srv02_volt_DWork.HILInitialize_Card,
         &q_srv02_volt_P.HILInitialize_POChannels[0], 8U,
         &q_srv02_volt_DWork.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(q_srv02_volt_M, _rt_error_message);
        return;
      }
    }
  }

  MdlInitialize();
}

void MdlTerminate(void)
{
  q_srv02_volt_terminate();
}

RT_MODEL_q_srv02_volt *q_srv02_volt(void)
{
  q_srv02_volt_initialize(1);
  return q_srv02_volt_M;
}

/*========================================================================*
 * End of GRT compatible call interface                                   *
 *========================================================================*/
